<?php defined('SYSPATH') or die('No direct script access.');

class Model_Serverstat extends ORM {
    
	protected $_table_name = 'serverstats';
	protected $_primary_key = 'name';
    
	protected $_table_columns = array(
		'name' => NULL,
		'value' => NULL,
		'title' => NULL,
		'order' => NULL,
		'updated_at' => NULL,
	);

    protected static $_meta = array(
        'Uptime' => array(
            'title' => 'Uptime',
            'order' => 0,
        ),
        'CountImport' => array(
            'title' => 'Available for import',
            'order' => 100,
        ),
        'LastInsert' => array(
            'title' => 'Last insert',
            'order' => 200,
        ),
        'CountClientsDbEstimate' => array(
            'title' => 'Count clients (:platform)',
            'order' => 300,
        ),
        'CountLogpostsDbEstimate' => array(
            'title' => 'Count logposts (:platform)',
            'order' => 400,
        ),
        'LocalSphinxStatus' => array(
            'title' => 'Local sphinx status',
            'order' => 500,
        ),
        'DistributedServerStats' => array(
            'title' => 'Distributed servers (sphinx)',
            'order' => 600,
        ),
        'CountClientsSphinx' => array(
            'title' => 'Count clients (sphinx)',
            'order' => 700,
        ),
        'CountLogpostsSphinx' => array(
            'title' => 'Count logposts (sphinx)',
            'order' => 800,
        ),
    );
    
    /**
     * Set server stat
     * 
     * @param string $name
     * @param string $value
     * @param array $name_params
     */
    public static function setStat($name, $value, array $name_params = null)
    {
        // Get title and subtitute title params
        $title = Arr::path(self::$_meta, $name . '.title', $name);
        if ( null !== $name_params )
        {
            $title = strtr($title, $name_params);
        }
        
        // Insert or update server stat
        $serverstat = ORM::factory('Serverstat', $name);
        $serverstat->name = $name;
        $serverstat->value = $value;
        $serverstat->title = $title;
        $serverstat->order = Arr::path(self::$_meta, $name . '.order', 0);
        $serverstat->updated_at = DB::expr('NOW()');
        $serverstat->save();
    }
    
    public function getValueFormatted()
    {
        if ( 'LastInsert' == $this->name )
        {
            if ( '' != $this->value )
            {
                $value = Helper::time_elapsed_string($this->value);
            }
            else
            {
                $value = 'not having records';
            }
        }
        else
        {
            $value = $this->value;
        }
        
        return $value;
    }
    
}